<?php

namespace App\Models;

use App\Constants\Status;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;
use Illuminate\Database\Eloquent\Factories\HasFactory;

class Invoice extends Model
{
    use HasFactory;

    public function user()
    {
        return $this->belongsTo(User::class);
    }
    
    public function merchant()
    {
        return $this->belongsTo(Merchant::class);
    }

    public function invoiceItem()
    {
        return $this->hasMany(InvoiceItem::class);
    }

    public function statusBadge(): Attribute
    {
        return new Attribute(function () {
            $html = '';
            if ($this->status == Status::PAID) {
                $html = '<span class="badge badge--success">' . trans('Paid') . '</span>';
            } elseif ($this->status == Status::UNPAID) {
                $html = '<span><span class="badge badge--primary">' . trans('Unpaid') . '</span>';
            } elseif ($this->status == Status::CANCELED) {
                $html = '<span><span class="badge badge--warning">' . trans('Canceled') . '</span> <button data-title="Cancel Reason" data-reason="'.$this->cancel_reason.'" class="ms-1 badge badge--warning rejectBtn" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Cancellation Reason"><i class="las la-exclamation-circle"></i></button>';
            } else {
                $html = '<span class="badge badge--danger">' . trans('Rejected') . '</span><button data-title="Rejected Reason" data-reason="'.$this->cancel_reason.'" class="ms-1 badge badge--warning rejectBtn" data-bs-toggle="tooltip" data-bs-placement="top" data-bs-title="Rejected Reason"><i class="las la-exclamation-circle"></i></button>';
            }
            return $html;
        });
    }

    public function scopePaid($q)
    {
        return $q->where('status', Status::PAID);
    }

    public function scopeUnpaid($q)
    {
        return $q->where('status', Status::UNPAID);
    }
}
