<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Frontend extends Model
{
    protected $casts = [
        'data_values' => 'object',
        'seo_content'=>'object'
    ];

    protected $appends = [];

    public function __construct(){
        if (request()->is('api/*')) {
            $this->appends[] = 'get_image';
        }
    }

    public function getGetImageAttribute(){
        if($this->data_keys == 'app_banner.element'){
            return getImage('assets/images/frontend/app_banner/' .@$this->data_values->image, '340x110');
        }

        return null;
    }


    public static function scopeGetContent($data_keys)
    {
        return Frontend::where('data_keys', $data_keys);
    }
}
