<?php

namespace App\Models;

use App\Constants\Status;
use App\Traits\ApiQuery;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;

class DpsPlan extends Model
{
    use GlobalStatus, ApiQuery;

    public function organization()
    {
        return $this->belongsTo(Organization::class);
    }

    public function savingTenure()
    {
        return $this->belongsTo(SavingTenure::class);
    }

    public function penaltyInterval()
    {
        return $this->belongsTo(SavingInterval::class, 'penalty_interval_id', 'id');
    }

    public function savingInterval()
    {
        return $this->belongsTo(SavingInterval::class);
    }

    public function investmentAmount()
    {
        return round($this->savingTenure->duration / $this->savingInterval->installment_interval) * $this->installment_amount;
    }

    // scope 

    public function scopeActive($query)
    {
        return $query->where('status', Status::ENABLE);
    }
}
