<?php

namespace App\Models;

use DB;

use App\Constants\Status;
use App\Traits\GlobalStatus;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Casts\Attribute;

class AutoPayment extends Model
{
    use GlobalStatus;
    protected $casts = [
        'user_data' => 'object',
    ];


    public function user()
    {
        return $this->belongsTo(User::class);
    }

    public function receiver()
    {
        return $this->belongsTo(User::class, 'receiver_id');
    }

    public function mobileOperator()
    {
        return $this->belongsTo(MobileOperator::class, 'operator_id');
    }

    public function setupUtilityBill()
    {
        return $this->belongsTo(SetupUtilityBill::class, 'utility_id');
    }

    public function scopeUtilityBill($q)
    {
        return $q->where('payment_type', 'utility_bill');
    }

    public function scopeSendMoney($q)
    {
        return $q->where('payment_type', 'send_money');
    }

    public function scopeMobileRecharge($q)
    {
        return $q->where('payment_type', 'mobile_recharge');
    }
}
