<?php

namespace App\Lib\Api;

use App\Constants\Status;
use App\Models\UserAction;

class UserActionProcess {

    public $user_id;
    public $user_type;
    public $act;
    public $type;
    public $next_route;
    public $expiration = 0;
    public $is_otp     = 1;
    public $details    = [];

    public $action_id      = 0;
    public $verify_api_otp = 0;

    public function submit() {

        $this->is_otp = Status::NO;

        if ($this->type) {
            $this->is_otp = Status::YES;
        }

        $general = gs();
        $user    = auth()->user();

        $userAction            = new UserAction();
        $userAction->user_id   = $user->id;
        $userAction->user_type = $this->user_type ?? 'USER';
        $userAction->act       = $this->act;
        $userAction->details   = $this->details;
        $userAction->is_otp    = $this->is_otp;
        $userAction->is_api    = Status::YES;

        if ($general->en || $general->sn || $user->ts) {
            $userAction->type       = $this->type;
            $userAction->otp        = verificationCode(6);
            $userAction->send_at    = now();
            $userAction->expired_at = now()->addSeconds((float) $general->otp_expiration);
        }

        $userAction->save();

        $this->action_id  = $userAction->id;
        $this->next_route = $this->details['done_route'];

        if ($this->is_otp == Status::YES) {
            $this->verify_api_otp = Status::YES;
            if ($this->type == 'email' || $this->type == 'sms') {
                notify($this->guard()['user'], 'OTP',
                    ['code' => $userAction->otp], [$this->type]
                );
            }
        }
    }

    public function guard() {

        $user     = auth()->user();
        $userType = strtoupper(substr($user->getTable(), 0, -1));

        if ($userType == 'USER') {
            $guard = 1;
        } else if ($userType == 'AGENT') {
            $guard = 2;
        } else if ($userType == 'MERCHANT') {
            $guard = 3;
        }

        return ['guard' => $guard, 'user_type' => $userType, 'user' => $user];
    }
}
