<?php

namespace App\Http\Middleware;

use App\Constants\Status;
use Closure;
use Illuminate\Http\Request;

class KycMiddleware
{
    /**
     * Handle an incoming request.
     *
     * @param  \Illuminate\Http\Request  $request
     * @param  \Closure(\Illuminate\Http\Request): (\Illuminate\Http\Response|\Illuminate\Http\RedirectResponse)  $next
     * @return \Illuminate\Http\Response|\Illuminate\Http\RedirectResponse
     */
    public function handle(Request $request, Closure $next, $guard = null, $action = null)
    {

        if ($guard) {
            $user = auth()->guard($guard)->user();
        } else {
            $guard = 'user';
            $user = auth()->user();
        }

        if (!$user && $request->is('api/*')) {
            $guard = 'user';
            $user = auth()->user();
        }

        if ($request->is('api/*') && ($user->kv == 0 || $user->kv == 2)) {
            if ($action) {
                $notify[] = 'You are unable to ' . strtolower(keyToTitle($action)) . ' due to KYC verification';
            } else {
                $notify[] = 'You are unable to do this action due to KYC verification';
            }
            return response()->json([
                'remark' => 'kyc_verification',
                'status' => 'error',
                'message' => ['error' => $notify],
            ]);
        }
        if ($user->kv == 0) {
            $notify[] = ['error', 'You are not KYC verified. For being KYC verified, please provide these information'];
            return to_route("$guard.kyc.form")->withNotify($notify);
        }
        if ($user->kv == 2) {
            $notify[] = ['warning', 'Your documents for KYC verification is under review. Please wait for admin approval'];
            return to_route("$guard.home")->withNotify($notify);
        }

        return $next($request);
    }
}
