<?php

namespace App\Http\Controllers\Api;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\RedeemReward;
use App\Models\Reward;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class RedeemRewardsController extends Controller
{

    public function list()
    {
        $redeemRewards = RedeemReward::active()
            ->with(['reward'])
            ->where('user_id', auth()->id())
            ->get();

        $notify[]      = ['success', 'Redeem rewards'];
        return responseSuccess('redeem_rewards', $notify, $redeemRewards);
    }

    public function store(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'reward_id' => 'required',
        ]);

        if ($validator->fails()) {
            return responseError('validation_error', $validator->errors());
        }

        $user = auth()->user();

        $reward = Reward::active()->find($request->reward_id);

        if (!$reward) {
            $notify[] = 'Reward not found';
            return responseError('not_found', $notify);
        }

        $redeemRewardExists = RedeemReward::active()
            ->where('user_id', $user->id)
            ->where('reward_id', $reward->id)
            ->exists();

        if ($redeemRewardExists) {
            $notify[] = 'You have already redeemed this reward';
            return responseError('validation_error', $notify);
        }

        if ($user->total_points < $reward->required_points) {
            $notify[] = 'You don\'t have enough points';
            return responseError('validation_error', $notify);
        }

        $user->total_points -= $reward->required_points;
        $user->save();

        // make reward claim
        $redeemReward              = new RedeemReward();
        $redeemReward->user_id     = $user->id;
        $redeemReward->reward_id   = $reward->id;
        $redeemReward->points_used = $reward->required_points;
        $redeemReward->expires_at  = now()->addDays($reward->validity_days);
        $redeemReward->status   = Status::ENABLE;
        $redeemReward->save();

        $notify[] = ['success', 'Reward redeemed successfully'];
        return responseSuccess('reward_redeemed', $notify);
    }
}
