<?php

namespace App\Http\Controllers\Api;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\PointLog;
use App\Models\RedeemReward;

class PointsController extends Controller
{
    public function earnedPoints()
    {
        $user     = auth()->user();
        $points   = $user->points;
        $notify[] = ['success', 'Points History'];

        return responseSuccess('points', $notify, $points);
    }

    public function expiredPoints()
    {
        $user    = auth()->user();
        $points  = PointLog::where('user_id', $user->id)
            ->where('status', Status::POINT_EXPIRED)
            ->selectRaw('DATE_FORMAT(expires_at, "%Y-%m-%d") as month, SUM(points) as total_points')
            ->groupBy('month')
            ->orderBy('month', 'desc')
            ->get();

        $notify[] = ['success', 'Expired Points'];

        return responseSuccess('points', $notify, $points);
    }

    public function usedPoints()
    {
        $user          = auth()->user();
        $pointsUsed    = RedeemReward::with('reward')
            ->where('user_id', $user->id)
            ->latest('id')
            ->get();

        $notify[] = ['success', 'Used Points'];

        return responseSuccess('points', $notify, $pointsUsed);
    }
}