<?php

namespace App\Http\Controllers\Api;

use App\Constants\Status;
use App\Models\UserAction;
use Illuminate\Http\Request;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Validator; 
use App\Traits\Common;

class OtpController extends Controller{

    use Common;

    public function otpResend(Request $request){
        
        $user = auth()->user();
     
        $general = gs();
        $userAction = $this->getAction($request->action_id);

        if(!$userAction){
            $notify[] = 'Something went wrong';
            return responseError('validation_error',$notify);
        }

        $userAction->otp = verificationCode(6);
        $userAction->send_at = now();
        $userAction->expired_at = now()->addSeconds((float)$general->otp_expiration);
        $userAction->save();
      
        if($userAction->type == '2fa'){
            $notify[] = 'Cannot sent 2FA verification';
            return responseError('validation_error',$notify);
        }

        notify(
            $user, 'OTP',
            ['code' => $userAction->otp],
            [$userAction->type]
        );

        $notify[] = 'OTP has been re-sent successfully';
        return responseSuccess('resend_otp',$notify);
    }

    public function otpVerify(Request $request){
     
        $validator = Validator::make($request->all(), [
            'code' => 'required',
            'action_id' => 'required',
        ]);

        if ($validator->fails()) {
            return responseError('validation_error',$validator->errors());
        }

        $code = str_replace(' ', '', $request->code);
        $userAction = $this->getAction($request->action_id);

        if (!$userAction) {
            $notify[] = 'Sorry! Unable to process';
            return responseError('validation_error',$notify);
        }
    
        if ($userAction->type == 'email' || $userAction->type == 'sms') {    
            if ($userAction->otp != $code) {
                $notify[] = 'OTP doesn\'t match';
                return responseError('validation_error',$notify);
            }
            if ($userAction->expired_at < now()) { 
                $notify[] = 'Your OTP has expired';
                return responseError('validation_error',$notify);
            }
        } else {
            $user = auth()->user();
            $response = verifyG2fa($user, $code);
            if (!$response) {
                $notify[] = 'Verification code doesn\'t match';
                return responseError('validation_error',$notify);
            }
        }
 
        $userAction->used_at = now();
        $userAction->save();

        return callApiMethod($userAction->details->done_route, $userAction->id);
    }

    protected function getAction($actionId){   
        
        $user = auth()->user();  
        $userType = $this->guard()['user_type'];

        return  UserAction::where('id', $actionId)->where('user_id', $user->id)
        ->where('user_type', $userType)
        ->where('is_otp', Status::YES)
        ->where('is_api', Status::YES)
        ->where('is_used', Status::NO)
        ->first(); 
    }

}
