<?php

namespace App\Http\Controllers\Api\Merchant\Auth;

use App\Http\Controllers\Controller;
use App\Models\UserLogin;
use Illuminate\Foundation\Auth\AuthenticatesUsers;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Validator;

class LoginController extends Controller
{ 
    /*
    |--------------------------------------------------------------------------
    | Login Controller
    |--------------------------------------------------------------------------
    |
    | This controller handles authenticating users for the application and
    | redirecting them to your home screen. The controller uses a trait
    | to conveniently provide its functionality to your applications.
    |
    */

    use AuthenticatesUsers;

    /**
     * Where to redirect users after login.
     *
     * @var string
     */

    protected $username;

    /**
     * Create a new controller instance.
     *
     * @return void
     */


    public function __construct()
    {   parent::__construct();
        $this->username = $this->findUsername();
    }

    public function login(Request $request)
    {  
        $validator = $this->validateLogin($request);

        if ($request->is_web) {
            if (!verifyCaptcha()) {
                $notify[] = 'Invalid captcha provided';
                return responseError('captcha_error', $notify);
            }
        }

        if ($validator->fails()) {
            return responseError('validation_error', $validator->errors());
        }

        $credentials = request([$this->username, 'password']);
        if(!Auth::guard('merchant')->attempt($credentials)){
            $notify[] = 'Unauthorized Merchant';
            return responseError('unauthorized_user', $notify);
        }
 
        $user = Auth::guard('merchant')->user();
        $tokenResult = $user->createToken('auth_token', ['merchant'])->plainTextToken;
        $this->authenticated($request,$user);
        
        if($user->is_deleted){
            $user->tokens()->delete();
            $notify[] = 'Unauthorized Merchant';
            return responseError('validation_error', $notify);
        }
        
        $notify[] = 'Login successfully';

        return responseSuccess('login_success', $notify, [
            'merchant' => $user,
            'access_token' => $tokenResult,
            'token_type' => 'Bearer'
        ]);
    }

    public function findUsername()
    {
        $login = request()->input('username');

        $fieldType = filter_var($login, FILTER_VALIDATE_EMAIL) ? 'email' : 'username';
        request()->merge([$fieldType => $login]);
        return $fieldType;
    }

    public function username()
    {
        return $this->username;
    }

    protected function validateLogin(Request $request)
    {
        $validation_rule = [
            $this->username() => 'required|string',
            'password' => 'required|string',
        ];

        $validate = Validator::make($request->all(),$validation_rule);
        return $validate;

    }

    public function logout()
    {   
        auth()->user('merchant')->tokens()->delete();
        $notify[] = 'Logout successfully';
        return responseSuccess('logout', $notify);
    }

    public function authenticated(Request $request, $user)
    {   
        $user->tv = $user->ts == 1 ? 0 : 1;
        $user->save();

        $ip = getRealIP();
        $exist = UserLogin::where('merchant_id',$ip)->first();
        $userLogin = new UserLogin();
        if ($exist) {
            $userLogin->longitude =  $exist->longitude;
            $userLogin->latitude =  $exist->latitude;
            $userLogin->city =  $exist->city;
            $userLogin->country_code = $exist->country_code;
            $userLogin->country =  $exist->country;
        }else{
            $info = json_decode(json_encode(getIpInfo()), true);
            $userLogin->longitude =  @implode(',',$info['long']);
            $userLogin->latitude =  @implode(',',$info['lat']);
            $userLogin->city =  @implode(',',$info['city']);
            $userLogin->country_code = @implode(',',$info['code']);
            $userLogin->country =  @implode(',', $info['country']);
        }

        $userMerchant = osBrowser();
        $userLogin->merchant_id = $user->id;
        $userLogin->user_ip =  $ip;

        $userLogin->browser = @$userMerchant['browser'];
        $userLogin->os = @$userMerchant['os_platform'];
        $userLogin->save();
    }


}
