<?php

namespace App\Http\Controllers\Api;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\Level;
use App\Models\PointLog;
use App\Models\RedeemReward;

class LevelRewardsController extends Controller
{

    public function data()
    {
        $notify[] = ['success', 'Level Rewards'];

        $user = auth()->user();
        $earnedPoints  = $user->points;
        $expiredPoints =  PointLog::where('user_id', $user->id)
            ->where('status', Status::POINT_EXPIRED)
            ->selectRaw('DATE_FORMAT(expires_at, "%Y-%m-%d") as month, SUM(points) as total_points')
            ->groupBy('month')
            ->orderBy('month', 'desc')
            ->get();

        $usedPoints = RedeemReward::with('reward')
            ->where('user_id', $user->id)
            ->latest('id')
            ->get();

        $levelRewards = Level::active()->with(['rewards'])->orderBy('min_points', 'asc')->get();
        $redeemRewards = RedeemReward::active()
            ->with(['reward'])
            ->where('user_id', $user->id)
            ->get();

        $rewardFaq = @getContent('rewards_faq.element');

        return responseSuccess('levels', $notify, [
            'user'           => $user,
            'earned_points'  => $earnedPoints,
            'expired_points' => $expiredPoints,
            'used_points'    => $usedPoints,
            'level_rewards'  => $levelRewards,
            'reward_faq'     => $rewardFaq,
            'redeem_rewards' => $redeemRewards
        ]);
    }

    public function levelWithRewards()
    {
        $notify[] = ['success', 'Level Rewards'];
        $levels = Level::active()->with(['rewards'])->orderBy('min_points', 'asc')->get();

        return responseSuccess('levels', $notify, $levels);
    }

    public function faq()
    {
        $rewardFaq = @getContent('rewards_faq.element');
        $notify[]  = ['success', 'Reward FAQ'];

        return responseSuccess('faq', $notify, $rewardFaq);
    }
}
