<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Controller;
use App\Models\PasswordReset;
use App\Models\User;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class ForgotPasswordController extends Controller
{
    public function sendResetCodeMobile(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'mobile' => 'required',
        ]);

        if ($validator->fails()) {
            return responseError('validation_error',$validator->errors());
        }

        $user = User::whereRaw("CONCAT(dial_code, mobile) = ?", [$request->mobile])->first();

        if (!$user) {
            $notify[] = 'Couldn\'t find any account with this information';
            return responseError('validation_error',$notify);
        }

        PasswordReset::where('mobile', $user->mobileNumber)->delete();
        $code                 = verificationCode(6);
        $password             = new PasswordReset();
        $password->mobile     = $user->mobileNumber;
        $password->token      = $code;
        $password->created_at = \Carbon\Carbon::now();
        $password->save();

        $userIpInfo      = getIpInfo();
        $userBrowserInfo = osBrowser();
        notify($user, 'PASS_RESET_CODE', [
            'code'             => $code,
            'operating_system' => @$userBrowserInfo['os_platform'],
            'browser'          => @$userBrowserInfo['browser'],
            'ip'               => @$userIpInfo['ip'],
            'time'             => @$userIpInfo['time'],
        ], ['sms']);

        $mobile     = $user->mobileNumber;
        $notify[] = 'Verification code sent to your mobile';
        return responseSuccess('code_sent',$notify,[
            'mobile' => $mobile,
        ]);
    }

    public function verifyCode(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'code'   => 'required',
            'mobile' => 'required',
        ]);

        if ($validator->fails()) {
            return responseError('validation_error',$validator->errors());
        }
        $code = $request->code;

        if (PasswordReset::where('token', $code)->where('mobile', $request->mobile)->count() != 1) {
            $notify[] = 'Verification code doesn\'t match';
            return responseError('validation_error',$notify);
        }

        $notify[] = 'You can change your pin.';
        return responseSuccess('verified',$notify);
    }

    public function reset(Request $request)
    {
        $validator = Validator::make($request->all(), $this->rules());

        if ($validator->fails()) {
            return responseError('validation_error',$validator->errors());
        }

        $reset = PasswordReset::where('token', $request->token)->where('mobile', $request->mobile)->orderBy('created_at', 'desc')->first();
        if (!$reset) {
            $notify[] = 'Invalid verification code';
            return responseError('validation_error',$notify);
            return response()->json([
                'remark'  => 'validation_error',
                'status'  => 'error',
                'message' => ['success' => $response],
            ]);
        }

        $user           = User::whereRaw("CONCAT(dial_code, mobile) = ?", [$reset->mobile])->first();
        $user->password = bcrypt($request->password);
        $user->save();

        $userIpInfo  = getIpInfo();
        $userBrowser = osBrowser();
        notify($user, 'PASS_RESET_DONE', [
            'operating_system' => @$userBrowser['os_platform'],
            'browser'          => @$userBrowser['browser'],
            'ip'               => @$userIpInfo['ip'],
            'time'             => @$userIpInfo['time'],
        ], ['sms']);

        $notify[] = 'Pin changed successfully';
        return responseSuccess('password_changed',$notify);
    }

    protected function rules()
    {
        return [
            'token'    => 'required',
            'mobile'   => 'required',
            'password' => ['required', 'confirmed', 'digits:4'],
        ];
    }
}
