<?php

namespace App\Http\Controllers\Api;

use App\Models\Language;
use App\Constants\Status;
use App\Models\ModuleSetting;
use App\Http\Controllers\Controller;

class AppController extends Controller
{
    public function generalSetting()
    {
        $notify[] = 'General setting data';

        $data = [
            'general_setting' => gs(),
            'social_login_redirect' => route('user.social.login.callback', ''),
        ];

        return responseSuccess('general_setting', $notify, $data);
    }

    public function moduleSetting()
    {
        $notify[] = 'Module setting data';

        $userModules     = ModuleSetting::where('user_type', 'USER')->get();
        $agentModules    = ModuleSetting::where('user_type', 'AGENT')->get();
        $merchantModules = ModuleSetting::where('user_type', 'MERCHANT')->get();

        return responseSuccess('module_setting', $notify, [
            'module_setting' => [
                'user'     => $userModules,
                'agent'    => $agentModules,
                'merchant' => $merchantModules,
            ],
        ]);
    }

    public function getCountries()
    {
        $countryData = json_decode(file_get_contents(resource_path('views/partials/country.json')));
        $notify[] = 'Country List';
        foreach ($countryData as $k => $country) {
            $countries[] = [
                'country' => $country->country,
                'dial_code' => $country->dial_code,
                'country_code' => $k,
            ];
        }

        return responseSuccess('country_data', $notify, [
            'countries' => $countries,
        ]);
    }

    public function getLanguage($code = null)
    {
        $languages = Language::get();
        $languageCodes = $languages->pluck('code')->toArray();
        if (($code && !in_array($code, $languageCodes))) {
            $notify[] = 'Invalid code given';
            return responseError('validation_error',$notify);
        }

        if (!$code) {
            $code = Language::where('is_default', Status::YES)->first()?->code ?? 'en';
        }

        $jsonFile = file_get_contents(resource_path('lang/' . $code . '.json'));

        $notify[] = 'Language';

        return responseSuccess('language', $notify, [
            'languages' => $languages,
            'file' => json_decode($jsonFile) ?? [],
            'code' => $code,
            'image_path' => getFilePath('language')
        ]);
    }

    public function policies()
    {
        $policies = getContent('policy_pages.element', orderById: true);
        $notify[] = 'All policies';

        return responseSuccess('policy_data', $notify, [
            'policies' => $policies,
        ]);
    }


    public function faq()
    {
        $faq = getContent('faq.element', orderById: true);
        $notify[] = 'FAQ';
        return responseSuccess('faq', $notify, ['faq' => $faq]);
    }
}
