<?php

namespace App\Http\Controllers\Agent;

use App\Constants\Status;
use App\Http\Controllers\Controller;
use App\Models\UserWithdrawMethod;
use App\Models\Withdrawal;
use App\Traits\WithdrawProcess;

class AgentWithdrawController extends Controller
{

    use WithdrawProcess;

    public function withdraw()
    {
        $userMethods = UserWithdrawMethod::myWithdrawMethod()->with('withdrawMethod')->get();
        $pageTitle   = 'Withdraw Money';
        return view('Template::agent.withdraw.withdraw_money', compact('pageTitle', 'userMethods'));
    }

    public function withdrawMethods()
    {
        $userMethods = UserWithdrawMethod::myWithdrawMethod()->with('withdrawMethod')->paginate(getPaginate());
        $pageTitle   = 'Withdraw Methods';
        return view('Template::agent.withdraw.methods', compact('pageTitle', 'userMethods'));
    }

    public function withdrawPreview()
    {
        $withdraw = Withdrawal::with('method', 'agent')->where('trx', session()->get('wtrx'))->where('status', Status::PAYMENT_INITIATE)->orderBy('id', 'desc')->first();
        if (!$withdraw) {
            $notify[] = ['error', 'Session not found'];
            return to_route('agent.withdraw')->withNotify($notify);
        }
        $pageTitle = 'Withdraw Preview';
        return view('Template::agent.withdraw.preview', compact('pageTitle', 'withdraw'));
    }

    public function withdrawLog()
    {
        $pageTitle = "Withdraw Log";

        $guard    = userGuard();
        $user     = $guard['user'];
        $userType = $guard['type'];

        $withdraws = Withdrawal::where('user_id', $user->id)->where('user_type', $userType)->where('status', '!=', Status::PAYMENT_INITIATE)->with('method')
            ->whereHas('method')->orderBy('id', 'desc')
            ->paginate(getPaginate());

        return view('Template::agent.withdraw.log', compact('pageTitle', 'withdraws'));
    }

    public function fileDownload($fileHash)
    {
        $filePath  = decrypt($fileHash);
        $extension = pathinfo($filePath, PATHINFO_EXTENSION);
        $general   = gs();
        $title     = slug($general->site_name) . '- attachments.' . $extension;
        $mimetype  = mime_content_type($filePath);
        header('Content-Disposition: attachment; filename="' . $title);
        header("Content-Type: " . $mimetype);
        return readfile($filePath);
    }
}
