<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\TransactionCharge;
use Illuminate\Http\Request;

class TransactionChargeController extends Controller
{
    public function manageCharges()
    {
        $pageTitle = "Limit & Charges";
        $charges   = TransactionCharge::cursor();

        $sendMoney      = $charges->where('slug', 'send_money')->first();
        $cashOutCharge  = $charges->where('slug', 'cash_out')->first();
        $cashInCharge   = $charges->where('slug', 'cash_in')->first();
        $paymentCharge  = $charges->where('slug', 'payment_charge')->first();
        $mobileRecharge = $charges->where('slug', 'mobile_recharge')->first();
        $bankTransfer   = $charges->where('slug', 'bank_transfer')->first();
        $apiCharge      = $charges->where('slug', 'api_charge')->first();
        $voucherCharge  = $charges->where('slug', 'voucher_charge')->first();
        $airtimeCharge  = $charges->where('slug', 'airtime_charge')->first();

        return view('admin.transaction_charges', compact('pageTitle', 'sendMoney', 'airtimeCharge', 'cashOutCharge', 'cashInCharge', 'paymentCharge', 'mobileRecharge', 'bankTransfer', 'apiCharge', 'voucherCharge'));
    }

    public function updateCharges(Request $request)
    {
        $validationRule = [
            'percentage_charge'               => 'numeric|between:0,100',
            'fixed_charge'                    => 'numeric|gte:0',
            'cap'                             => 'numeric|gte:-1',
            'min_limit'                       => 'numeric|gte:0',
            'max_limit'                       => 'numeric|gt:min_limit',
            'monthly_limit'                   => 'numeric|gte:-1',
            'daily_limit'                     => 'numeric|gte:-1',
            'agent_commission_fixed'          => 'numeric|gte:0',
            'agent_commission_percent'        => 'numeric|gte:0',
            'merchant_payment_percent_charge' => 'numeric|gte:0',
            'merchant_payment_fixed_charge'   => 'numeric|gte:0',
            'user_payment_percent_charge'     => 'numeric|gte:0',
            'referral_percentage_commission'  => 'numeric|gte:0',
            'referral_fixed_commission'       => 'numeric|gte:0',
        ];

        if ($request->id == 1) {
            $validationRule['daily_request_accept_limit']   = 'numeric|gte:0';
            $validationRule['monthly_request_accept_limit'] = 'numeric|gt:daily_request_accept_limit';
        }

        $request->validate($validationRule);

        if ($request->monthly_limit != -1 && $request->monthly_limit < $request->daily_limit) {
            $notify[] = ['error', 'The daily limit must not exceed the monthly limit.'];
            return back()->withNotify($notify);
        }

        $charge = TransactionCharge::findOrFail($request->id);

        $charge->daily_request_accept_limit   = $request->daily_request_accept_limit;
        $charge->monthly_request_accept_limit = $request->monthly_request_accept_limit;

        $charge->percent_charge                  = $request->percentage_charge;
        $charge->fixed_charge                    = $request->fixed_charge;
        $charge->min_limit                       = $request->min_limit;
        $charge->max_limit                       = $request->max_limit;
        $charge->cap                             = $request->cap;
        $charge->agent_commission_fixed          = $request->agent_com_fixed;
        $charge->agent_commission_percent        = $request->agent_com_percent;
        $charge->merchant_payment_percent_charge = $request->merchant_payment_percent_charge;
        $charge->merchant_payment_fixed_charge   = $request->merchant_payment_fixed_charge;
        $charge->user_payment_percent_charge     = $request->user_payment_percent_charge;
        $charge->user_payment_fixed_charge       = $request->user_payment_fixed_charge;
        $charge->monthly_limit                   = $request->monthly_limit;
        $charge->daily_limit                     = $request->daily_limit;
        $charge->referral_percentage_commission  = $request->referral_percentage_commission;
        $charge->referral_fixed_commission       = $request->referral_fixed_commission;
        $charge->save();

        $notify[] = ['success', 'Limit & charge updated successfully'];
        return back()->withNotify($notify);
    }
}
