<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SetupDonation;
use App\Rules\FileTypeValidate;

class SetupDonationController extends Controller
{
    public function all(){ 
        $pageTitle = 'Setup Donations';
        $donations = SetupDonation::searchable(['name'])->paginate(getPaginate());
        return view('admin.setup_donation.all',compact('pageTitle', 'donations'));
    }
    
    public function add(){
		
		$this->formSubmit();

    	$notify[] = ['success', 'Successfully added donation setup'];
	    return back()->withNotify($notify);
    }

	public function update(){

		$this->formSubmit(update:true);

    	$notify[] = ['success', 'Successfully updated donation setup'];
	    return back()->withNotify($notify);
    }

	private function formSubmit($update = false){
		$request = request();
		$rule = [
    		'name' => 'required|max:255|unique:setup_donations,name,'.$request->id,
    		'details' => 'required',
    	];
     
		if($update){
			$rule['id'] = 'required|integer';
            $rule['image'] = ['nullable','image',new FileTypeValidate(['jpg','jpeg','png'])];
		}else{
            $rule['image'] = ['required','image',new FileTypeValidate(['jpg','jpeg','png'])];
        }
	
		$request->validate($rule);
 
		if($update){
			$donation = SetupDonation::findOrFail($request->id); 
		}else{
			$donation = new SetupDonation(); 
		}
		
        if ($request->hasFile('image')) {
            try {
                $old = $donation->image;
                $donation->image = fileUploader($request->image, getFilePath('setup_donation'), getFileSize('setup_donation'), $old);
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }

    	$donation->name = $request->name;
    	$donation->details = $request->details;
    	$donation->save();

		return $donation;
	}

	public function status($id){ 
		return SetupDonation::changeStatus($id);
	}
}
