<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Lib\FormProcessor;
use App\Models\SetupBankTransfer;
use App\Rules\FileTypeValidate;
use Illuminate\Http\Request;

class SetupBankTransferController extends Controller
{
    public function all()
    {
        $pageTitle = 'Setup Bank Transfer';
        $banks     = SetupBankTransfer::searchable(['name'])->with('form')->paginate(getPaginate());
        return view('admin.setup_bank_transfer.all', compact('pageTitle', 'banks'));
    }

    public function save(Request $request, $id = 0)
    {
        $imageValidation = $id ? 'nullable' : 'required';

        $request->validate([
            'name'  => 'required',
            'image' => [$imageValidation, 'image', new FileTypeValidate(['jpg', 'jpeg', 'png'])],
        ]);

        if ($id) {
            $bank     = SetupBankTransfer::findOrFail($id);
            $notify[] = ['success', 'Bank transfer setup updated successfully'];
        } else {
            $bank     = new SetupBankTransfer();
            $notify[] = ['success', 'Bank transfer setup added successfully'];
        }

        if ($request->hasFile('image')) {
            try {
                $bank->image = fileUploader($request->image, getFilePath('setup_bank'), getFileSize('setup_bank'), $bank->image);
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }

        $bank->name = $request->name;
        $bank->save();

        return back()->withNotify($notify);
    }

    public function configure($id)
    {
        $pageTitle = 'Configure Bank Transfer';
        $bank      = SetupBankTransfer::findOrFail($id);
        return view('admin.setup_bank_transfer.form', compact('pageTitle', 'bank'));
    }

    public function saveConfigure($id)
    {
        $setup          = SetupBankTransfer::findOrFail($id);
        $formProcessor  = new FormProcessor();
        $generate       = $formProcessor->generate('setup_bank_transfer_' . $setup->id, true);
        $setup->form_id = @$generate->id ?? 0;
        $setup->save();

        $notify[] = ['success', 'Bank transfer setup configured successfully'];
        return back()->withNotify($notify);
    }

    public function status($id)
    {
        return SetupBankTransfer::changeStatus($id);
    }
}
