<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SavingTenure;
use Illuminate\Http\Request;

class SavingsTenureController extends Controller
{
    public function all()
    {
        $pageTitle     = 'Saving Tenures';
        $savingTenures = SavingTenure::orderBy('duration', 'asc')->get();

        return view('admin.savings.tenures', compact('pageTitle', 'savingTenures'));
    }

    public function add(Request $request, $id = 0)
    {
        $request->validate([
            'name'     => 'required|string|max:40',
            'duration' => 'required|integer|gt:0',
        ]);

        if ($id) {
            $savingType = SavingTenure::findOrFail($id);
            $message    = 'Savings tenure updated successfully';
        } else {
            $savingType = new SavingTenure();
            $message    = 'Savings tenure added successfully';
        }

        $savingType->name     = $request->name;
        $savingType->duration = $request->duration;
        $savingType->save();

        $notify[] = ['success', $message];
        return back()->withNotify($notify);
    }

    public function status($id)
    {
        return SavingTenure::changeStatus($id);
    }
}
