<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Frontend;
use Illuminate\Http\Request;

class SavingsPolicyController extends Controller
{
    public function index()
    {
        $pageTitle = 'Savings Policy';
        $policy = Frontend::where('data_keys', 'savings.policy')->first();
        return view('admin.savings.policy', compact('pageTitle', 'policy'));
    }

    public function updatePolicy(Request $request)
    {
        $request->validate([
            'description' => 'required'
        ]);

        $purifier = new \HTMLPurifier();
        $description =  htmlspecialchars_decode($purifier->purify($request->description));

        $policy = Frontend::where('data_keys', 'savings.policy')->first();

        if (!$policy) {
            $policy = new Frontend();
            $policy->data_keys = 'savings.policy';
        }

        $policy->data_values = ['description' => $description];
        $policy->save();

        $notify[] = ['success', 'Savings policy updated successfully'];
        return back()->withNotify($notify);
    }
}
