<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\SavingInterval;
use Illuminate\Http\Request;

class SavingsIntervalController extends Controller
{
    public function all()
    {
        $pageTitle = 'Saving Intervals';
        $intervals = SavingInterval::orderBy('installment_interval', 'asc')->get();

        return view('admin.savings.intervals', compact('pageTitle', 'intervals'));
    }

    public function add(Request $request, $id = 0)
    {
        $request->validate([
            'name'                 => 'required|string|max:40',
            'installment_interval' => 'required|integer|gt:0',
        ]);

        if ($id) {
            $savingType = SavingInterval::findOrFail($id);
            $message    = 'Savings interval updated successfully';
        } else {
            $savingType = new SavingInterval();
            $message    = 'Savings interval added successfully';
        }

        $savingType->name                 = $request->name;
        $savingType->installment_interval = $request->installment_interval;
        $savingType->save();

        $notify[] = ['success', $message];
        return back()->withNotify($notify);
    }

    public function status($id)
    {
        return SavingInterval::changeStatus($id);
    }
}
