<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Lib\FormProcessor;
use App\Models\Form;
use Illuminate\Http\Request;

class SavingNomineeController extends Controller
{
    public function form()
    {
        $pageTitle = 'Nominee Form Setting';
        $form = Form::where('act', 'nominee_form')->first();
        return view('admin.savings.nominee_form', compact('pageTitle', 'form'));
    }

    public function updateForm(Request $request)
    {
        $formProcessor = new FormProcessor();
        $generatorValidation = $formProcessor->generatorValidation();
        $request->validate($generatorValidation['rules'], $generatorValidation['messages']);

        $exist = Form::where('act', 'nominee_form')->first();

        if ($exist) {
            $isUpdate = true;
        } else {
            $isUpdate = false;
        }

        $formProcessor->generate('nominee_form', $isUpdate, 'act');

        $notify[] = ['success', 'Nominee form data updated successfully'];
        return back()->withNotify($notify);
    }
}
