<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\PenaltyInterval;
use Illuminate\Http\Request;

class PenaltyIntervalController extends Controller
{
    public function all()
    {
        $pageTitle = 'Penalty Intervals';
        $intervals = PenaltyInterval::orderBy('duration', 'asc')->get();
        return view('admin.savings.penalty_intervals', compact('pageTitle', 'intervals'));
    }

    public function add(Request $request, $id = 0)
    {
        $request->validate([
            'name'     => 'required|string',
            'duration' => 'required|numeric',
        ]);

        if ($id) {
            $penaltyInterval = PenaltyInterval::findOrFail($id);
            $message = 'Penalty interval updated successfully';
        } else {
            $penaltyInterval = new PenaltyInterval();
            $message = 'Penalty interval added successfully';
        }

        $penaltyInterval->name     = $request->name;
        $penaltyInterval->duration = $request->duration;
        $penaltyInterval->save();

        $notify[] = ['success', $message];
        return back()->withNotify($notify);
    }

    public function status($id)
    {
        return PenaltyInterval::changeStatus($id);
    }
}
