<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\MobileOperator;
use App\Rules\FileTypeValidate;

class MobileOperatorController extends Controller
{
    public function all(){
        $pageTitle = 'All Mobile Operators';
        $operators = MobileOperator::searchable(['name'])->paginate(getPaginate());
        return view('admin.mobile_operator.all',compact('pageTitle', 'operators'));
    }
    
    public function add(){
 
		$this->formSubmit();

    	$notify[] = ['success', 'Mobile operator added successfully'];
	    return back()->withNotify($notify);
    }

	public function update(){

		$this->formSubmit(update:true);

    	$notify[] = ['success', 'Mobile operator updated successfully'];
	    return back()->withNotify($notify);
    }

	private function formSubmit($update = false){
       
		$request = request();
		$rule = [
    		'name' => 'required|max:255|unique:mobile_operators,name,'.$request->id,
    	];

		if($update){
			$rule['id'] = 'required|integer';
            $rule['image'] = ['nullable','image',new FileTypeValidate(['jpg','jpeg','png'])];
		}else{
            $rule['image'] = ['required','image',new FileTypeValidate(['jpg','jpeg','png'])];
        }
        
		$request->validate($rule);
	
		if($update){
			$operator = MobileOperator::findOrFail($request->id); 
		}else{
			$operator = new MobileOperator; 
		}
		
        if ($request->hasFile('image')) {
            try {
                $old = $operator->image;
                $operator->image = fileUploader($request->image, getFilePath('mobile_operator'), getFileSize('mobile_operator'), $old);
            } catch (\Exception $exp) {
                $notify[] = ['error', 'Couldn\'t upload your image'];
                return back()->withNotify($notify);
            }
        }

    	$operator->name = $request->name;
    	$operator->save();

		return $operator;
	}

	public function status($id){ 
		return MobileOperator::changeStatus($id);
	}
}
