<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\Invoice;

class InvoiceController extends Controller
{

    public function index()
    {
        $pageTitle = 'Invoice All';
        $invoices = Invoice::with(['user', 'merchant'])->searchable(['uid', 'user:username', 'merchant:username'])->filter(['status'])->orderBy('id', 'desc')->paginate(getPaginate());
        return view('admin.invoice.index', compact('pageTitle', 'invoices'));
    }

    public function download($id)
    {
        $pageTitle = 'invoice';
        $invoice = Invoice::with(['user', 'merchant'])->findOrFail($id);
        return downloadPDF('invoice.download', compact('invoice', 'pageTitle'));
    }
}
