<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\AutoPayment;

class AutoPaymentController extends Controller
{

    public function active()
    {
        $pageTitle = 'Active Auto Payments';
        $autoPayments     = $this->autoPaymentData('active');
        return view('admin.auto_payment.index', compact('pageTitle', 'autoPayments'));
    }

    public function inactive()
    {
        $pageTitle = 'Inactive Auto Payments';
        $autoPayments     = $this->autoPaymentData('inactive');
        return view('admin.auto_payment.index', compact('pageTitle', 'autoPayments'));
    }

    public function all()
    {
        $pageTitle = 'All Auto Payments';
        $autoPayments     = $this->autoPaymentData('');
        return view('admin.auto_payment.index', compact('pageTitle', 'autoPayments'));
    }

    protected function autoPaymentData($scope = null)
    {
        if ($scope) {
            $autoPayments = AutoPayment::$scope();
        } else {
            $autoPayments = AutoPayment::query();
        }
        return $autoPayments->searchable(['user:username', 'user:email'])->filter(['payment_type','payment_days'])->with(['user','receiver','mobileOperator'])->orderBy('id', 'desc')->paginate(getPaginate());
    }
}
