(function ($) {
  ("use strict");

  // ============== Cursor over Start ========
  function mousemoveHandler(e) {
    try {
      let tl = gsap.timeline({
        defaults: {
          x: e.clientX,
          y: e.clientY,
        },
      });

      // Main pointer Moving
      tl.to(".cursor", {
        ease: "power2.out",
      }).to(
        ".cursor-dot", {
          ease: "power2.out",
        },
        "-=0.4"
      );
    } catch (err) {
      console.log(err);
    }
  }
  document.addEventListener("mousemove", mousemoveHandler);

  // ============== Cursor over End ========
  // ============== Header Hide Click On Body Js Start ========
  $(".header-button").on("click", function () {
    $(".body-overlay").toggleClass("show");
  });
  $(".body-overlay").on("click", function () {
    $(".header-button").trigger("click");
    $(this).removeClass("show");
  });
  // =============== Header Hide Click On Body Js End =========

  // ==========================================
  //      Start Document Ready function
  // ==========================================
  $(document).ready(function () {
    // ========================== Header Hide Scroll Bar Js Start =====================
    $(".navbar-toggler.header-button").on("click", function () {
      $("body").toggleClass("scroll-hide-sm");
    });
    $(".body-overlay").on("click", function () {
      $("body").removeClass("scroll-hide-sm");
    });
    // ========================== Header Hide Scroll Bar Js End =====================

    // ========================== Small Device Header Menu On Click Dropdown menu collapse Stop Js Start =====================
    $(".dropdown-item").on("click", function () {
      $(this).closest(".dropdown-menu").addClass("d-block");
    });
    // ========================== Small Device Header Menu On Click Dropdown menu collapse Stop Js End =====================
  });

  // ========================= Preloader Js Start =====================
  $(window).on("load", function () {
    $(".preloader").fadeOut();
  });
  // ========================= Preloader Js End=====================

  // // ========================= Header Sticky Js Start ==============
  $(window).on("scroll", function () {
    if ($(window).scrollTop() >= 300) {
      $(".header").addClass("fixed-header");
    } else {
      $(".header").removeClass("fixed-header");
    }
  });
  // // ========================= Header Sticky Js End===================

  // //============================ Scroll To Top Icon Js Start =========
  var btn = $(".scroll-top");

  $(window).scroll(function () {
    if ($(window).scrollTop() > 300) {
      btn.addClass("show");
    } else {
      btn.removeClass("show");
    }
  });

  btn.on("click", function (e) {
    e.preventDefault();
    $("html, body").animate({
      scrollTop: 0
    }, "300");
  });

  // //========================= Scroll To Top Icon Js End ======================

  // //========================= about scroll effect Js Start ======================

  function setParentWidthToChild(child) {
    return child.width(child.parent().width());
  }

  function mobileSetImg() {

    const mobileQuery = window.matchMedia("(max-width: 768px)");
    const allMobileImg = document.querySelectorAll(
      "#features .left-content img"
    );

    if (mobileQuery.matches) {
      $(".pin-spacer").css({
        backgroundColor: "black"
      });
      const allChildren = document.querySelectorAll(".contentMarker");
      allChildren.forEach((item) => {
        const itemAttr = item.getAttribute("data-marker-content");
        let getSectionImg = "";
        const dynamicImage = document.createElement("img");

        allMobileImg.forEach((img) => {
          if (itemAttr === img.id) {
            getSectionImg = img.getAttribute("src");
            dynamicImage.src = img.getAttribute("src");
            dynamicImage.alt = "Featured Image";
          }
        });

        item.querySelector("div.mobile-img").appendChild(dynamicImage);
      });
    }
  }
  mobileSetImg();

  function reOrder() {

    $(".center-child").addClass("customm");
    setParentWidthToChild($(".center"));
    let scroll = $(window).scrollTop(),
      topContent = $(".about-us-content").position();
    if (!topContent) {
      return false;
    }
    
    topContent = topContent.top - 100,
      sectionHeight = $(".left").height(),
      centerHeight = $(".center-child").height(),
      bottomContent = topContent + sectionHeight - centerHeight;

    if (scroll > topContent && scroll < bottomContent) {
      $(".customm").removeClass("posAbs").addClass("posFix");
    } else if (scroll > bottomContent) {

      $(".customm").removeClass("posFix").addClass("posAbs");
      $(".center-child h2").text("fixed");
    } else if (scroll < topContent) {
      $(".customm").removeClass("posFix");
    }
  }
  $(window).scroll(reOrder);
  $(window).resize(reOrder);

  //========================= about scroll effect Js End ======================

  //========================= Navigation Text Start ======================
  $(document).ready(function () {
    $(".nav-item .nav-link").html(function () {
      return (
        '<div class="nav-text"><span>' +
        $(this).text().split("").join("</span><span>") +
        "</span></div>"
      );
    });

    $(".nav-text span").each(function () {
      var item = $(this);
      if (item.html() == " ") {
        item.css(
          "width",
          parseInt(
            getComputedStyle(item[0], null)
            .getPropertyValue("font-size")
            .replace("px", "")
          ) /
          3 +
          "px"
        );
      }
    });

  });
  //========================= Navigation Text End ======================

  //=========================Slider  Scroll js Start ======================
  (() => {
    const mq = window.matchMedia("(min-width: 992px)");
    if (!mq.matches) return;
    const getSection = document.querySelectorAll(".main-feature .feature")
    $(".main-feature").css({
      width: `${100 * getSection.length}%`
    })
    let sections = gsap.utils.toArray(".main-feature .feature");
    gsap.to(sections, {
      xPercent: -100 * (sections.length - 1),
      ease: "none",
      scrollTrigger: {
        trigger: ".main-feature",
        pin: true,
        scrub: 1,
        snap: 1 / (sections.length - 1),
        end: `+=${$(".feature").width()}`,
      }
    });
  })();
  //=========================Slider  Scroll js End ======================

  //=========================Click to change img Start ======================
  const triggerItem = document.querySelectorAll(
    ".account-complete-process .process-item"
  );
  const processThumb = document.querySelectorAll(
    ".feature .section-img.process-thumb img"
  );

  $(".account-complete-process .process-item").on("click", function () {
    triggerItem.forEach((list) => list.classList.remove("active"));
    $(this).addClass("active");

    processThumb.forEach((item) => {
      item.setAttribute("hidden", "true");
      if ($(this).data("change-img") == item.id) {
        item.removeAttribute("hidden");
      }
    });
  });

  //=========================Click to change img End ======================

  // Remove Warning from
  gsap.config({
    trialWarn: false
  });

  // Timeline Animation
  (() => {
    const tl = gsap.timeline();

    tl.from(".banner-content__title ", {
      y: 500,
      opacity: 0,
      zIndex: -1,
      duration: 0.5,
    });
    tl.from(".left .thumb img", {
      x: "-1000",
      duration: 0.1,
      opacity: 0,
      overflowX: "hidden",
    }).from(".right .thumb img", {
      x: "-1000",
      duration: 0.3,
      opacity: 0,
      overflowX: "hidden",
    });
  })();

  $(document).ready(function () {
    $('html, body').animate({
      scrollTop: 5
    }, 'slow');
  });
})(jQuery);